// Adapted from "Goldname" by Calgon

uniform sampler2D texture0;
uniform sampler2D texture1;
uniform float u_Elapsed;

#define iTime u_Elapsed;



/////////////////////////////////////////////////////////////////////////////////
// Scene Input variables
uniform float cycle_time; 	// Duration of the full cycle
uniform float alpha_on; 	// Time in cycle to switch on alpha channel
uniform float alpha_off; 	// Switch off alpha

uniform float alpha_on2; 	// Time in cycle to switch on alpha channel
uniform float alpha_off2; 	// Switch off alpha
uniform float set_r; 	// Duration of the full cycle
uniform float set_g; 	// Time in cycle to switch on alpha channel
uniform float set_b; 	// Switch off alpha



float part_cycles = 0.;
float original_alpha = 0.;




varying vec4 gl_TexCoord[];
float weight=0.14767;
// changes and additions by WyldAnimal of the totem occluding.fsh shader used 
// here to make a static color clip name.

void main(void)

{
	vec4 vTexCoord = gl_TexCoord[0];
	vTexCoord.x = pow(vTexCoord.x,2.0);
	
	vec4 occluding = texture2D(texture0, vec2(vTexCoord.x , vTexCoord.y )) ;
	original_alpha = occluding.a;

	part_cycles = u_Elapsed;
	for (int i = 0; i < 3000; i++) {
		if (part_cycles >= cycle_time){
			part_cycles -= cycle_time;
			if (part_cycles < cycle_time){
			  i = 3000;
			}
			
		}
	}
	
	occluding.a = 0.;
	float max_alpha = 0.75;
	
	
	if (part_cycles > alpha_on){
		if (part_cycles < alpha_off){
			occluding.a = max_alpha;
		}
	}
	if (part_cycles > alpha_on2){
		if (part_cycles < alpha_off2){
			occluding.a = max_alpha;
		}
	}
	if (original_alpha < .5){
		occluding.a = 0.;
	}

	

	gl_FragColor = vec4(set_r,set_g,set_b,occluding.a);
	
	
	
	
}


